class Solution {
public:
    void merge(vector<int>& nums, int left, int mid, int right) 
    {
        vector<int> temp(right - left + 1);
        int i = left, j = mid + 1, k = 0;
        while (i <= mid && j <= right) 
        {
            if (nums[i] <= nums[j])
            {
                temp[k++] = nums[i++];
            } else {
                temp[k++] = nums[j++];
            }
        }
        while (i <= mid)
        {
            temp[k++] = nums[i++];
        }
        while (j <= right)
        {
            temp[k++] = nums[j++];
        }
        
        for (int p = 0; p < k; p++)
        {
            nums[left + p] = temp[p];
        }
    }
    
    void merge_sort(vector<int>& nums, int left, int right)
    {
        if (left >= right)
        {
            return;
        }
        
        int mid = (left + right) / 2;
        merge_sort(nums, left, mid);T
        merge_sort(nums, mid+1, right);
        merge(nums, left, mid, right);
    }
    
    vector<int> sortArray(vector<int>& nums)
    {
        merge_sort(nums, 0, nums.size()-1);
        return nums;
    }
};

// TIME COMPLEXITY - O(nlogn)
// SPACE COMPLEXITY - O(n)
